/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;

    public ObjectiveFunction(IVecInt vars, IVec<BigInteger> coeffs) {
        this.vars = new VecInt(vars.size());
        vars.copyTo(this.vars);
        this.coeffs = new Vec<BigInteger>(coeffs.size());
        coeffs.copyTo(this.coeffs);
    }

    public BigInteger calculateDegree(int[] model) {
        BigInteger tempDegree = BigInteger.ZERO;
        int i = 0;
        while (i < this.vars.size()) {
            if (this.varInModel(this.vars.get(i), model)) {
                tempDegree = tempDegree.add(this.coeffs.get(i));
            }
            ++i;
        }
        return tempDegree;
    }

    private boolean varInModel(int var, int[] model) {
        int i = 0;
        while (i < model.length) {
            if (var == model[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IVec<BigInteger> getCoeffs() {
        Vec<BigInteger> coefbis = new Vec<BigInteger>(this.coeffs.size());
        this.coeffs.copyTo(coefbis);
        return coefbis;
    }

    public IVecInt getVars() {
        VecInt varbis = new VecInt(this.vars.size());
        this.vars.copyTo(varbis);
        return varbis;
    }
}

