/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.sat4j.csp.xml.CspXmlParser;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.reader.CSPReader;
import org.sat4j.reader.CSPSupportReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.xml.sax.SAXException;

public class XMLCSPReader
extends Reader {
    private CSPReader cspreader;

    public XMLCSPReader(ISolver solver) {
        this.cspreader = new CSPSupportReader(solver);
    }

    public String decode(int[] model) {
        return this.cspreader.decode(model);
    }

    public void decode(int[] model, PrintWriter out) {
        this.cspreader.decode(model, out);
    }

    public IProblem parseInstance(String filename) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        try {
            CspXmlParser.parse((ICSPCallback)this.cspreader, (String)filename);
        }
        catch (SAXException e) {
            throw new ParseFormatException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ParseFormatException(e);
        }
        return this.cspreader.getProblem();
    }

    public IProblem parseInstance(java.io.Reader in) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException();
    }

    public void setVerbosity(boolean b) {
        super.setVerbosity(b);
        this.cspreader.setVerbosity(b);
    }
}

