/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.Serializable;
import org.sat4j.specs.ContradictionException;

public class DimacsArrayToDimacsConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected StringBuilder dimacs;
    private final int bufSize;

    public DimacsArrayToDimacsConverter(int bufSize) {
        this.bufSize = bufSize;
    }

    protected boolean handleConstr(int gateType, int output, int[] inputs) throws ContradictionException {
        int[] nArray = inputs;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int var = nArray[n];
            this.dimacs.append(var);
            this.dimacs.append(" ");
            ++n;
        }
        this.dimacs.append("0\n");
        return true;
    }

    public String parseInstance(int[] gateType, int[] outputs, int[][] inputs, int maxVar) throws ContradictionException {
        this.initDimacs();
        this.dimacs.append(maxVar);
        this.dimacs.append("\n");
        int i = 0;
        while (i < outputs.length) {
            this.handleConstr(gateType[i], outputs[i], inputs[i]);
            ++i;
        }
        String result = this.dimacs.toString();
        this.dimacs = null;
        return result;
    }

    protected void initDimacs() {
        this.dimacs = new StringBuilder(this.bufSize);
        this.dimacs.append("p cnf ");
    }

    public String decode(int[] model) {
        StringBuilder stb = new StringBuilder();
        int i = 0;
        while (i < model.length) {
            stb.append(model[i]);
            stb.append(" ");
            ++i;
        }
        stb.append("0");
        return stb.toString();
    }
}

