/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class ModelIterator
extends SolverDecorator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean trivialfalsity = false;

    public ModelIterator(ISolver solver) {
        super(solver);
    }

    public int[] model() {
        int[] last = super.model();
        VecInt clause = new VecInt(last.length);
        int[] nArray = last;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int q = nArray[n];
            clause.push(-q);
            ++n;
        }
        try {
            this.addClause(clause);
        }
        catch (ContradictionException e) {
            this.trivialfalsity = true;
        }
        return last;
    }

    public boolean isSatisfiable() throws TimeoutException {
        if (this.trivialfalsity) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        if (this.trivialfalsity) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(assumps);
    }

    public void reset() {
        this.trivialfalsity = false;
        super.reset();
    }
}

